# Features
* Improved caching of posts, taxonomy translation data, and strings
* Improved general performance
* Improved menus synchronization performances
* New hooks added (see https://wpml.org/documentation/support/wpml-coding-api/wpml-hooks-reference/)
* Wildcard entries for admin string settings now work for sub-keys on all levels in addition to top-level keys

# Fixes
* Access
* Changing admin language on one site (multisite) does not sets admin language on all sites anymore
* Fixed "This is a translation of" being empty when creating a new translation
* Fixed "This is a translation of" so it's enabled correctly
* Fixed 'wpml_active_languages' filter so it returns languages with correct data
* Fixed a potential security issue
* Fixed an issue in where attachments were wrongfully filtered by language and hence not displayed in the front-end in some cases
* Fixed an issue preventing subsites in a subdirectory multisite setup from completing the last setup step
* Fixed domain name mapping when a domain name in one language includes the domain name from another language
* Fixed issue where urls pointing at hidden laguage posts were redirected incorrectly when usinging the languages as parameters setting
* Fixed issues resolving hierarchical page URLs when parent and child use the same page-slug
* Fixed language switcher not filtering out empty date archive translations
* Fixed missing parentheses in mobile switcher
* Fixed page template being unchangeable in translated content, after deactivating the "Synchronize page template" setting
* Fixed problem with Greek characters in taxonomy names causing problems with taxonomy translations editor
* Fixed redirection issues when the same slug is used in translations with hierarchical post types
* Fixed several glitches and issues related to the menus synchronization
* Fixed WPML breaking XML-RPC calls
* Fixed wrong order of languages when using `icl_get_languages` with `orderby=name`
* MU Domain Mapping
* Removed creation of duplicated 'update_wpml_config_index' cron job
* Removed errors when deactivating WPML for a subsite in multisite install
* When 'Language as Parameter' is used, wp_link_pages() pagination produce now a properly formed URL
* WooCommerce