<?php
// Add new input type "radio-image"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('radio-image' , 'radio_image_settings_field' );
}

add_action('admin_enqueue_scripts','smile_radio_image_scripts');
function smile_radio_image_scripts($hook){
	$cp_page = strpos( $hook, CP_PLUS_SLUG );
	$data  =  get_option( 'convert_plug_debug' );
	
	if( $cp_page !== false && ( isset( $data['cp-dev-mode'] ) && $data['cp-dev-mode'] == '1' )  && isset( $_GET['style-view'] ) && ( $_GET['style-view'] == "edit" || $_GET['style-view'] == "variant" ) ){
		wp_enqueue_style('smile-radio-image',SMILE_FRAMEWORK_URI . '/lib/fields/radio-image/radio-image.css');
		wp_enqueue_script('smile-radio-image',SMILE_FRAMEWORK_URI . '/lib/fields/radio-image/radio-image.js',array(),'1.0.0',true);
	}
}
/**
* Function to handle new input type "radio-image"
*
* @param $settings		- settings provided when using the input type "radio-image"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function radio_image_settings_field($name, $settings, $value)
{
	$input_name = $name;
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';
	$options = isset($settings['options']) ? $settings['options'] : '';
	$max_width = isset($settings['width']) ? $settings['width'] : '';
	$image_title = isset($settings['imagetitle']) ? $settings['imagetitle'] : '';

	$output = '';
	$n = 0;
 	$img_title ='';
 	
 		
	foreach ( $options as $key => $img ) {
		$checked = $cls = '';
		if ( $value !== '' && (string)$key === (string)$value ) {
			$checked = ' checked="checked"';
			$cls = 'selected';
		}
		if($image_title !==''){	 		
	 		$description = $image_title["title-$n"];
	 		$img_title = 'title = "'.$description.'"';
	 	}
		$output .= '<div class="smile-radio-image-holder '.$cls.'">';
		// $output .= '<input type="radio" name="' . $input_name . '" value="'.$key.'" id="smile_'.$key.'_'.$n.'" class="form-control smile-input smile-'.$type.' ' . $input_name . ' ' . $type . '" '.$checked.'> <label for="smile_'.$key.'_'.$n.'" class="smile-radio-control"><img style="max-width: '.$max_width.';" class="smile-radio-control" src="'.$img.'"/></label>';
		$output .= '<input type="radio" name="' . $input_name . '" value="'.$key.'" data-id="smile_'.$input_name.'" class="form-control smile-input smile-'.$type.' ' . $input_name . ' ' . $type . '" '.$checked.'> <label for="smile_'.$key.'_'.$n.'" class="smile-radio-control"><img style="max-width: '.$max_width.';" class="smile-radio-control '.$input_name . '-' . $key.'" src="'.$img.'" '.$img_title.'/></label>';

		$output .= '</div>';
		$n++;
	}
	return '<div class="smile-radio-image-wrapper">'.$output.'</div>';
}